import { VFC, useEffect, useRef, useState } from 'react';

import { useEnvContext } from '@client/shared/libs/env';
import { Block, Widget, YandexConfig } from '@yandex-int/messenger.widget';
import '@yandex-int/messenger.widget/lib/ui/block.css';

import { SERVICE_ID, WORKSPACE_ID, flags, themeVariables } from './constants';
import { getPresets, getSupportChatByAlias } from './utils';

import styles from './Support.module.css';

export interface SupportProps {
  guid?: string;
}

const ui = new Block();

export const Support: VFC<SupportProps> = ({ guid }) => {
  const { yenv } = useEnvContext();
  const widgetContainerRef = useRef(null);
  const [widget, setWidget] = useState<Widget | null>(null);

  useEffect(() => {
    const widgetConfig = new YandexConfig(...getPresets(yenv), {
      flags,
      themeVariables,
      serviceId: SERVICE_ID,
      workspaceId: WORKSPACE_ID,
      allow: ['microphone', 'camera'],
    });

    setWidget(new Widget(widgetConfig).setUI(ui));
  }, [yenv]);

  useEffect(() => {
    if (!widgetContainerRef.current || !widget) {
      return;
    }

    widget.init();
    ui.mount(widgetContainerRef.current);

    return () => {
      widget.destroy();
    };
  }, [widget]);

  useEffect(() => {
    if (!widget) {
      return;
    }

    widget.show({
      guid: guid ? getSupportChatByAlias(guid) || guid : undefined,
      chatList: guid ? undefined : true,
    });
  }, [guid, widget]);

  return <div className={styles.root} ref={widgetContainerRef} />;
};
