import { YEnv } from '@shared/types/env';
import { presets } from '@yandex-int/messenger.widget';

import { SUPPORT_CHAT_ALIASES } from './constants';

export function getSupportChatByAlias(alias: string) {
  const env = process.env.NODE_ENV;

  const aliases = SUPPORT_CHAT_ALIASES[env === 'production' ? 'production' : 'test'];

  return aliases[alias];
}

export function getPresets(yenv: YEnv) {
  if (yenv === 'development' || yenv === 'testing') {
    return [presets.backend.test];
  }

  return [presets.backend.prod];
}
