import { VFC } from 'react';

import { useWebsitePasswordsWidgetQuery } from '@client/shared/api/graphql';
import { useEnvContext } from '@client/shared/libs/env';
import { useAvatarsPath } from '@client/shared/paths';
import { YandexAppPromo } from '@client/shared/ui-kit/YandexAppPromo';

import { i18n } from './i18n';

import styles from './WebsitePasswords.module.css';

export const WebsitePasswords: VFC = () => {
  const { loading, data, error } = useWebsitePasswordsWidgetQuery();
  const avatarsHost = useAvatarsPath();
  const {
    language,
    ua: { mobileOsFamily, isMobile },
  } = useEnvContext();

  if (loading || error || !data) {
    return null;
  }

  const { viewer } = data;
  const { avatarId } = viewer;

  return (
    <div className={styles.root}>
      <YandexAppPromo
        lang={language.id}
        usrImg={`${avatarsHost}/get-yapic/${avatarId}/islands-300`}
        title={i18n('Пароли от сайтов можно хранить в приложении Яндекс {logo}', {
          logo: '{logo}',
        })}
        installMessage={i18n('Установить приложение Яндекс')}
        description={i18n(
          'В приложении Яндекс пароли от сайтов сохраняются автоматически, их не нужно запоминать. Это безопасно — пароли хранятся зашифрованными.{break}Чтобы посмотреть сохранённые пароли, откройте в приложении свой профиль {avatar} и нажмите Пароли.',
          {
            break: '{break}',
            avatar: '{avatar}',
          },
        )}
        device={isMobile ? mobileOsFamily : 'desktop'}
      />
    </div>
  );
};
