/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */

/* eslint-disable @typescript-eslint/no-use-before-define */
import { VFC } from 'react';

import { AddressEditorDialog } from '@client/features/address-editor';
import { LocationOutline } from '@client/shared/icons';
import { useIdPaths } from '@client/shared/paths';
import { Carousel, CarouselItem, List, ListItemLink, Section } from '@client/shared/ui-kit';

import { useAddressesList } from './api';
import { AddressCard } from './ui/AddressCard/AddressCard';
import { AddressCardSkeleton } from './ui/AddressCard/AddressCardSkeleton';

export const AddressesCards: VFC = () => {
  const idPaths = useIdPaths();

  return (
    <Section>
      <Section.Title anchor="addresses">Адреса</Section.Title>
      <Section.Description>
        Для заказа в один клик и чтобы не вводить в Навигаторе
      </Section.Description>

      <AddressesCardsCarousel />

      <List>
        <ListItemLink icon={<LocationOutline />} text="Все адреса" href={idPaths.addresses} />
      </List>
    </Section>
  );
};

const AddressesCardsCarousel: VFC = () => {
  const { data: addresses, error, isLoading } = useAddressesList();

  if (isLoading) {
    return (
      <Carousel>
        <AddressCardSkeleton />
        <AddressCardSkeleton />
        <AddressCardSkeleton />
      </Carousel>
    );
  }

  if (!addresses || error) {
    return null;
  }

  return (
    <>
      <Carousel>
        {addresses.map((address, key) => (
          <CarouselItem key={key}>
            <AddressCard {...address} />
          </CarouselItem>
        ))}
      </Carousel>

      <AddressEditorDialog />
    </>
  );
};
