/* eslint-disable @typescript-eslint/no-use-before-define */

/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC } from 'react';

import { AddressEditorDialog } from '@client/features/address-editor';
import { List, Section, SectionStack } from '@client/shared/ui-kit';

import { useAddressesList } from './api';
import { AddressListItem } from './ui/AddressListItem/AddressListItem';
import { AddressListItemSkeleton } from './ui/AddressListItem/AddressListItemSkeleton';

export const AddressesList: VFC = () => {
  return (
    <SectionStack>
      <Section>
        <Section.Title>Адреса</Section.Title>
        <Section.Description>
          Для заказа в один клик и чтобы не вводить в Навигаторе
        </Section.Description>

        <AddressesListContent />
      </Section>
    </SectionStack>
  );
};

const AddressesListContent: VFC = () => {
  const { data: addresses, error, isLoading } = useAddressesList();

  if (isLoading) {
    return (
      <List>
        <AddressListItemSkeleton />
        <AddressListItemSkeleton />
        <AddressListItemSkeleton />
      </List>
    );
  }

  if (!addresses || error) {
    return null;
  }

  return (
    <>
      <List>
        {addresses.map((address, key) => (
          <AddressListItem key={key} {...address} />
        ))}
      </List>

      <AddressEditorDialog />
    </>
  );
};
