import { useMemo } from 'react';

import {
  AddressType,
  AddressesListWidgetDataQuery,
  useAddressesListWidgetDataQuery,
} from '@client/shared/api/graphql';

export { AddressType } from '@client/shared/api/graphql';

export type Address = AddressesListWidgetDataQuery['addresses'][number];

export function useAddressesList() {
  const { data, error, loading } = useAddressesListWidgetDataQuery();

  return useMemo(() => {
    if (loading || error || !data) {
      return { data: null, error, isLoading: loading };
    }

    const homeAddress = data.addresses.find((address) => address.type === AddressType.Home) ?? {
      type: AddressType.Home,
    };
    const workAddress = data.addresses.find((address) => address.type === AddressType.Work) ?? {
      type: AddressType.Work,
    };
    const otherAddresses = [
      ...data.addresses.filter((address) => address.type === AddressType.Other),
      { type: AddressType.Other },
    ];

    const addresses = [homeAddress, workAddress, ...otherAddresses] as Address[];

    return {
      data: addresses,
      error,
      isLoading: loading,
    };
  }, [data, error, loading]);
}
