/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useCallback } from 'react';

import { addressModel } from '@client/features/address-editor';
import { Business, Home, LocationOutline } from '@client/shared/icons';
import { ListItemAction } from '@client/shared/ui-kit';

import { Address as AddressListItemProps, AddressType } from '../../api';

export const AddressListItem: VFC<AddressListItemProps> = (props) => {
  const { id, type, shortText, region } = props;

  const label = getLabel(type);
  const fallbackText = getFallbackText(type);
  const IconType = getIconType(type);

  const isExists = Boolean(id);

  const onPress = useCallback(() => {
    addressModel.addressPressed(props);
  }, [props]);

  return (
    <ListItemAction
      description={isExists ? `${region}` : undefined}
      icon={<IconType />}
      onPress={onPress}
      text={isExists ? `${label}${shortText}` : fallbackText}
      type={isExists ? 'kebab' : 'add'}
    />
  );
};

function getLabel(type: AddressType) {
  const label = {
    [AddressType.Home]: 'Дом',
    [AddressType.Work]: 'Работа',
    [AddressType.Other]: '',
  }[type];

  if (label) {
    return `${label} • `;
  }

  return label;
}

function getFallbackText(type: AddressType) {
  return {
    [AddressType.Home]: 'Добавить домашний адрес',
    [AddressType.Work]: 'Добавить рабочий адрес',
    [AddressType.Other]: 'Добавить ещё один адрес',
  }[type];
}

function getIconType(type: AddressType) {
  return {
    [AddressType.Home]: Home,
    [AddressType.Work]: Business,
    [AddressType.Other]: LocationOutline,
  }[type];
}
