/* eslint-disable @typescript-eslint/no-use-before-define */
import { useStore } from 'effector-react';
import { VFC } from 'react';

import {
  DocumentThumb as DocumentThumbEntity,
  DocumentThumbSkeleton,
} from '@client/entities/document-thumb';
import {
  AddDocumentsFrequently,
  AddDocumentsList,
  DocumentEditor,
} from '@client/features/document-editor';
import { DocumentVerticalBottomIcon } from '@client/shared/icons';
import { useIdPaths } from '@client/shared/paths';
import {
  Carousel,
  CarouselItem,
  Dialog,
  List,
  ListItemLink,
  Section,
  SectionStack,
} from '@client/shared/ui-kit';

import { useDocumentsList } from './api';
import { DocumentThumb } from './components';
import { ADD_DOCUMENTS_CAROUSEL_ITEMS } from './constants';
import * as model from './model';

import styles from './DocumentsThumbs.module.css';

export const DocumentsThumbs: VFC = () => {
  const idPaths = useIdPaths();

  return (
    <Section>
      <Section.Title anchor="documents">Документы</Section.Title>
      <Section.Description>
        В ID ваши документы всегда под рукой. А мы бережно их храним
      </Section.Description>

      <DocumentsThumbsCarousel />

      <List>
        <ListItemLink
          icon={<DocumentVerticalBottomIcon />}
          text="Все документы"
          href={idPaths.documents}
        />
      </List>
    </Section>
  );
};

const DocumentsThumbsCarousel: VFC = () => {
  const { data: documents, error, isLoading } = useDocumentsList();

  const isAddDocumentsDialogVisible = useStore(model.addDocumentsDialog.$isVisible);

  if (isLoading) {
    return (
      <Carousel>
        <CarouselItem>
          <DocumentThumbSkeleton />
        </CarouselItem>
        <CarouselItem>
          <DocumentThumbSkeleton />
        </CarouselItem>
        <CarouselItem>
          <DocumentThumbSkeleton />
        </CarouselItem>
      </Carousel>
    );
  }

  if (!documents || error) {
    return null;
  }

  return (
    <>
      {documents.length === 0 && <AddDocumentsCarousel />}
      {documents.length > 0 && (
        <Carousel>
          {documents.map((document) => (
            <CarouselItem key={document.id}>
              <DocumentThumb document={document} />
            </CarouselItem>
          ))}
          <CarouselItem>
            <DocumentThumbEntity
              icon={<DocumentVerticalBottomIcon />}
              onPress={model.addDocumentsDialog.show}
            >
              <DocumentThumbEntity.Title>Добавить ещё один документ</DocumentThumbEntity.Title>
            </DocumentThumbEntity>
          </CarouselItem>
        </Carousel>
      )}

      <DocumentEditor />
      <Dialog
        className={styles.dialog}
        hasClose
        visible={isAddDocumentsDialogVisible}
        onClose={model.addDocumentsDialog.hide}
      >
        <SectionStack className={styles.sectionStack}>
          <Section className={styles.section}>
            <AddDocumentsFrequently onTilePress={model.addDocumentsDialog.hide} />
          </Section>
          <Section className={styles.section}>
            <AddDocumentsList onItemPress={model.addDocumentsDialog.hide} />
          </Section>
        </SectionStack>
      </Dialog>
    </>
  );
};

const AddDocumentsCarousel: VFC = () => {
  return (
    <Carousel>
      {ADD_DOCUMENTS_CAROUSEL_ITEMS.map((item) => (
        <CarouselItem key={item.type}>
          <DocumentThumbEntity icon={item.icon} onPress={item.onPress}>
            <DocumentThumbEntity.Title>{item.title}</DocumentThumbEntity.Title>
          </DocumentThumbEntity>
        </CarouselItem>
      ))}
    </Carousel>
  );
};
