import { useMemo } from 'react';

import { DocumentType, useDocumentsThumbsWidgetDataQuery } from '@client/shared/api/graphql';

export type ThumbItem = {
  id: string;
  type: DocumentType;
  firstName?: string | null;
  lastName?: string | null;
  model?: string | null;
};

const documentTypeToOrder = {
  [DocumentType.NationalId]: 1,
  [DocumentType.InternationalId]: 2,
  [DocumentType.BirthCertificate]: 3,
  [DocumentType.DriverLicense]: 4,
  [DocumentType.VehicleRegistrationCertificate]: 5,
  [DocumentType.MedicalInsurance]: 6,
  [DocumentType.VoluntaryMedicalInsurance]: 7,
  [DocumentType.Inn]: 8,
  [DocumentType.Snils]: 9,
};

export function useDocumentsList() {
  const { data, error, loading } = useDocumentsThumbsWidgetDataQuery();

  return useMemo(() => {
    if (loading || error || !data) {
      return { data: null, error, isLoading: loading };
    }

    const documents = data.documents
      .reduce<ThumbItem[][]>((acc, document) => {
        const bucket = documentTypeToOrder[document.type];

        if (acc[bucket]) {
          acc[bucket].push(document);
        } else {
          acc[bucket] = [document];
        }

        return acc;
      }, [])
      .flat();

    return {
      data: documents,
      error,
      isLoading: loading,
    };
  }, [data, error, loading]);
}
