import { VFC } from 'react';

import {
  BirthCertificateThumb,
  DriverLicenseThumb,
  InnThumb,
  InternationalIdThumb,
  MedicalInsuranceThumb,
  NationalIdThumb,
  SnilsThumb,
  VehicleRegistrationCertificateThumb,
  VoluntaryMedicalInsuranceThumb,
} from '@client/features/document-editor';
import { DocumentType } from '@client/shared/api/graphql';

import { ThumbItem } from '../api';

export interface DocumentThumbProps {
  document: ThumbItem;
}

export const DocumentThumb: VFC<DocumentThumbProps> = (props) => {
  const { document } = props;

  switch (document.type) {
    case DocumentType.BirthCertificate:
      return (
        <BirthCertificateThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.DriverLicense:
      return (
        <DriverLicenseThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.Inn:
      return (
        <InnThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.InternationalId:
      return (
        <InternationalIdThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.MedicalInsurance:
      return (
        <MedicalInsuranceThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.NationalId:
      return (
        <NationalIdThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.Snils:
      return (
        <SnilsThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
    case DocumentType.VehicleRegistrationCertificate:
      return (
        <VehicleRegistrationCertificateThumb model={document.model} documentId={document.id} />
      );
    case DocumentType.VoluntaryMedicalInsurance:
      return (
        <VoluntaryMedicalInsuranceThumb
          firstName={document.firstName}
          lastName={document.lastName}
          documentId={document.id}
        />
      );
  }
};
