import { openDialog } from '@client/features/document-editor';
import { DocumentType } from '@client/shared/api/graphql';
import {
  BabyOutlineIcon,
  CarOutlineIcon,
  DmsOutlineIcon,
  DocumentHorizontalLeftIcon,
  DocumentVerticalTopIcon,
  DriverLicenseIcon,
  MedicineIcon,
  PassportIcon,
  PlaneIcon,
} from '@client/shared/icons';

export const ADD_DOCUMENTS_CAROUSEL_ITEMS = [
  {
    type: DocumentType.NationalId,
    icon: <PassportIcon />,
    title: 'Добавить паспорт РФ',
    onPress: () => {
      openDialog(DocumentType.NationalId, {});
    },
  },
  {
    type: DocumentType.InternationalId,
    icon: <PlaneIcon />,
    title: 'Добавить загранпаспорт',
    onPress: () => {
      openDialog(DocumentType.InternationalId, {});
    },
  },
  {
    type: DocumentType.BirthCertificate,
    icon: <BabyOutlineIcon />,
    title: 'Добавить св-во о рождении',
    onPress: () => {
      openDialog(DocumentType.BirthCertificate, {});
    },
  },
  {
    type: DocumentType.DriverLicense,
    icon: <DriverLicenseIcon />,
    title: 'Добавить ВУ',
    onPress: () => {
      openDialog(DocumentType.DriverLicense, {});
    },
  },
  {
    type: DocumentType.VehicleRegistrationCertificate,
    icon: <CarOutlineIcon />,
    title: 'Добавить СТС',
    onPress: () => {
      openDialog(DocumentType.VehicleRegistrationCertificate, {});
    },
  },
  {
    type: DocumentType.MedicalInsurance,
    icon: <MedicineIcon />,
    title: 'Добавить ОМС',
    onPress: () => {
      openDialog(DocumentType.MedicalInsurance, {});
    },
  },
  {
    type: DocumentType.VoluntaryMedicalInsurance,
    icon: <DmsOutlineIcon />,
    title: 'Добавить ДМС',
    onPress: () => {
      openDialog(DocumentType.VoluntaryMedicalInsurance, {});
    },
  },
  {
    type: DocumentType.Inn,
    icon: <DocumentVerticalTopIcon />,
    title: 'Добавить ИНН',
    onPress: () => {
      openDialog(DocumentType.Inn, {});
    },
  },
  {
    type: DocumentType.Snils,
    icon: <DocumentHorizontalLeftIcon />,
    title: 'Добавить СНИЛС',
    onPress: () => {
      openDialog(DocumentType.Snils, {});
    },
  },
];
