import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { FamilyMembersWidget } from '@client/widgets/FamilyMembers';
import { FamilyShortcuts } from '@client/widgets/FamilyShortcuts';

import { i18n } from './i18n';

const FamilyPage: NextPage = () => {
  return (
    <>
      <DocumentTitle>{i18n('Семья')}</DocumentTitle>
      <SectionStack>
        <FamilyShortcuts />
        <FamilyMembersWidget />
      </SectionStack>
    </>
  );
};

export default FamilyPage;
