import { DocumentTitle } from '@client/shared/libs/document-title';
import { useQueryParams } from '@client/shared/libs/router';
import { NextPage } from '@client/shared/page-layouts';
import { Support } from '@client/widgets/Support';

import { i18n } from './i18n';

interface QueryParams {
  guid: string;
}

const HelpdeskPage: NextPage = () => {
  const { guid } = useQueryParams<QueryParams>();

  return (
    <>
      <DocumentTitle>{i18n(`Поддержка`)}</DocumentTitle>
      <Support guid={guid} />
    </>
  );
};

export default HelpdeskPage;
