import NextHead from 'next/head';

import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { Documents } from '@client/widgets/Documents/Documents';

const IFrameDocumentsPage: NextPage = () => {
  return (
    <>
      <NextHead>
        <link
          rel="manifest"
          // TODO: непонятно как версионировать через yastatic
          href="https://yastatic.net/s3/yandex-id-static/documents-manifest.json"
        />
      </NextHead>
      <SectionStack>
        <Documents />
      </SectionStack>
    </>
  );
};

IFrameDocumentsPage.getLayout = (page) => page;

export default IFrameDocumentsPage;
