import { MockedResponse } from '@apollo/client/testing';
import {
  AuthType,
  SecurityBannerDataDocument,
  SecurityBannerDataQuery,
} from '@client/shared/api/graphql';

export const EMPTY_DATA: ReadonlyArray<MockedResponse<SecurityBannerDataQuery>> = [
  {
    request: {
      query: SecurityBannerDataDocument,
    },
    result: {
      data: {
        account: {
          id: '100500',
          authType: AuthType.PasswordOnly,

          question: null,

          phones: [],

          emails: [],
        },
      },
    },
  },
];
