import { MockedResponse } from '@apollo/client/testing';
import {
  AuthType,
  EmailType,
  SecurityBannerDataDocument,
  SecurityBannerDataQuery,
} from '@client/shared/api/graphql';

export const FULL_DATA: ReadonlyArray<MockedResponse<SecurityBannerDataQuery>> = [
  {
    request: {
      query: SecurityBannerDataDocument,
    },
    result: {
      data: {
        account: {
          id: '100500',
          authType: AuthType.PasswordAndSms,

          question: {
            id: '99',
          },

          phones: [
            {
              id: '70012345678',
              isPrimary: true,
            },
          ],

          emails: [
            {
              address: 'acme@domain.com',
              type: EmailType.External,
              isPrimary: false,
              isConfirmed: true,
            },
          ],
        },
      },
    },
  },
];
