import React from 'react';

import { Meta, Story } from '@storybook/react';

import HomePage from '../index.page';
import * as mocks from './__mock__';

export default {
  title: 'Hermione/HomePage',

  args: {
    graphql: 'FULL_DATA',
  },

  argTypes: {
    graphql: {
      control: 'select',
      mapping: mocks,
      options: Object.keys(mocks),
    },
  },
} as Meta;

const styles = `
  body {
    padding: 0 !important;
  }

  ::-webkit-scrollbar {
    display: none !important;
    width: 0 !important;
    background-color: transparent !important;
  }
`;

const imagesStyles = `
  img {
    visibility: hidden;
  }
`;

interface StoryArgs {
  images: boolean;
}

export const Default: Story<StoryArgs> = (args) => {
  return (
    <>
      <style>{styles}</style>
      {!args.images && <style>{imagesStyles}</style>}
      <HomePage />
    </>
  );
};

Default.args = {
  images: true,
};
