import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';

import { BannerTwister } from './ui/BannerTwister';
import { FamilySectionGrid } from './ui/FamilySectionGrid';
import { PaymentsSectionGrid } from './ui/PaymentsSectionGrid';
import { PersonalSectionGrid } from './ui/PersonalSectionGrid';
import { SectionStack } from './ui/SectionStack';
import { SecuritySectionGrid } from './ui/SecuritySectionGrid';
import { SubscriptionsSectionGrid } from './ui/SubscriptionsSectionGrid';

const IndexPage: NextPage = () => {
  return (
    <>
      <DocumentTitle />

      <SectionStack>
        <BannerTwister />
        <PersonalSectionGrid />
        <PaymentsSectionGrid />
        <FamilySectionGrid />
        <SecuritySectionGrid />
        <SubscriptionsSectionGrid />
      </SectionStack>
    </>
  );
};

export default IndexPage;
