import { useMemo } from 'react';

import { createBanner, createBannerGroup, useBanner } from '@client/shared/libs/banner-system';
import { useEnvContext } from '@client/shared/libs/env';

import { Section } from '../Section';
import { useSecurityData } from './api';
import { EnterMethodsBanner } from './banners/EnterMethodsBanner';
import { InsecurityBanner } from './banners/InsecurityBanner';
import { PhoneBanner } from './banners/PhoneBanner';
import { SecurityCompletedBanner } from './banners/SecurityCompletedBanner';
import { bannerSystem } from './models/banner-system';

export const BannerTwister = () => {
  const securityData = useSecurityBannersData();
  const SecurityBanner = useBanner(bannerSystem, securityData);

  if (securityData?.banners.length === 0) {
    return (
      <Section>
        <SecurityCompletedBanner />
      </Section>
    );
  }

  if (!SecurityBanner) {
    return null;
  }

  return (
    <Section>
      <SecurityBanner />
    </Section>
  );
};

function useSecurityBannersData() {
  const data = useSecurityData();
  const { viewer } = useEnvContext();

  const { uid = '' } = viewer;

  return useMemo(() => {
    if (data.isLoading) {
      return null;
    }

    const securityGroup = createBannerGroup({ display: 'all', key: uid });

    if (!data.hasPhone) {
      securityGroup.banners.push(createBanner({ id: 'PhoneBanner', value: PhoneBanner }));
    }

    if (!data.hasControlQuestion || !data.hasRecoveryEmail) {
      securityGroup.banners.push(
        createBanner({ id: 'EnterMethodsBanner', value: EnterMethodsBanner }),
      );
    }

    if (!data.hasTwoFa) {
      securityGroup.banners.push(createBanner({ id: 'InsecurityBanner', value: InsecurityBanner }));
    }

    return securityGroup;
  }, [data, uid]);
}
