import { AuthType, EmailType, useSecurityBannerDataQuery } from '@client/shared/api/graphql';

export function useSecurityData() {
  const { data, error, loading } = useSecurityBannerDataQuery();

  if (!data || error || loading) {
    return {
      isLoading: loading,
    };
  }

  const hasControlQuestion = data.account.question !== undefined;
  const hasPhone = data.account.phones.some((phone) => phone.isPrimary);
  const hasRecoveryEmail = data.account.emails.some(
    (email) => email.type !== EmailType.Native && email.isConfirmed && !email.isPrimary,
  );
  const hasTwoFa =
    data.account.authType === AuthType.PasswordAndSms ||
    data.account.authType === AuthType.YandexKey;

  return {
    hasControlQuestion,
    hasPhone,
    hasRecoveryEmail,
    hasTwoFa,
  };
}
