/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent } from 'effector-react';
import { useRouter } from 'next/router';
import { VFC, useCallback } from 'react';

import shieldRedAsset from '@client/shared/assets/shield-red.png';
import { logProps } from '@client/shared/libs/metrika';
import { useIdPaths } from '@client/shared/paths';
import { BannerCard } from '@client/shared/ui-kit';

import { bannerSystem } from '../models/banner-system';

export const EnterMethodsBanner: VFC = () => {
  const router = useRouter();
  const idPaths = useIdPaths();

  const onAction = useCallback(() => {
    router.push(idPaths.securityEnterMethods);
  }, [idPaths, router]);
  const onDismiss = useEvent(bannerSystem.dismiss);

  return (
    <BannerCard cover={shieldRedAsset} color="red-200">
      <BannerCard.Title>Усильте защиту</BannerCard.Title>
      <BannerCard.Text>Выберите надёжный и простой способ входа</BannerCard.Text>

      <BannerCard.Actions>
        <BannerCard.Button
          variant="primary"
          onPress={onAction}
          {...logProps('page.home.enter-methods-banner-choose')}
        >
          Выбрать
        </BannerCard.Button>
        <BannerCard.Button
          variant="secondary"
          onPress={onDismiss}
          {...logProps('page.home.enter-methods-banner-dismiss')}
        >
          Не сейчас
        </BannerCard.Button>
      </BannerCard.Actions>
    </BannerCard>
  );
};
