/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent } from 'effector-react';
import { useRouter } from 'next/router';
import { VFC, useCallback } from 'react';

import shieldRedAsset from '@client/shared/assets/shield-red.png';
import { logProps } from '@client/shared/libs/metrika';
import { useIdPaths } from '@client/shared/paths';
import { BannerCard } from '@client/shared/ui-kit';

import { bannerSystem } from '../models/banner-system';

export const InsecurityBanner: VFC = () => {
  const router = useRouter();
  const idPaths = useIdPaths();

  const onAction = useCallback(() => {
    router.push(idPaths.security);
  }, [idPaths, router]);
  const onDismiss = useEvent(bannerSystem.dismiss);

  return (
    <BannerCard cover={shieldRedAsset} color="red-200">
      <BannerCard.Title>Безопасность под угрозой</BannerCard.Title>
      <BannerCard.Text>Защитите аккаунт в разделе Безопасность</BannerCard.Text>

      <BannerCard.Actions>
        <BannerCard.Button
          variant="primary"
          onPress={onAction}
          {...logProps('page.home.insecurity-banner-protect')}
        >
          Усилить защиту
        </BannerCard.Button>
        <BannerCard.Button
          variant="secondary"
          onPress={onDismiss}
          {...logProps('page.home.insecurity-banner-dismiss')}
        >
          Не сейчас
        </BannerCard.Button>
      </BannerCard.Actions>
    </BannerCard>
  );
};
