/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent } from 'effector-react';
import { useRouter } from 'next/router';
import { VFC, useCallback } from 'react';

import shieldRedAsset from '@client/shared/assets/shield-red.png';
import { logProps } from '@client/shared/libs/metrika';
import { usePassportPaths } from '@client/shared/paths';
import { BannerCard } from '@client/shared/ui-kit';

import { bannerSystem } from '../models/banner-system';

export const PhoneBanner: VFC = () => {
  const router = useRouter();
  const passportPaths = usePassportPaths();

  const onAction = useCallback(() => {
    router.push(passportPaths.phones);
  }, [passportPaths, router]);
  const onDismiss = useEvent(bannerSystem.dismiss);

  return (
    <BannerCard cover={shieldRedAsset} color="red-200">
      <BannerCard.Title>Усильте защиту</BannerCard.Title>
      <BannerCard.Text>Добавьте телефон для защиты аккаунта</BannerCard.Text>

      <BannerCard.Actions>
        <BannerCard.Button
          variant="primary"
          onPress={onAction}
          {...logProps('page.home.phone-banner-add')}
        >
          Добавить
        </BannerCard.Button>
        <BannerCard.Button
          variant="secondary"
          onPress={onDismiss}
          {...logProps('page.home.phone-banner-dismiss')}
        >
          Не сейчас
        </BannerCard.Button>
      </BannerCard.Actions>
    </BannerCard>
  );
};
