/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useMemo } from 'react';

import { usePassportPaths } from '@client/shared/paths';

// import kidsAsset from '../../assets/kids.png';
import listAsset from '../../assets/list.png';
import paymentAsset from '../../assets/payment.png';
import type { GridData } from '../../types';
import { Card } from '../Card';
import { MansoryGrid } from '../MansoryGrid';
import { Section } from '../Section';

export const FamilySectionGrid: VFC = () => {
  const section = useSectionData();

  return (
    <Section>
      <Section.Title href={section.href} logEvent={section.logEvent}>
        {section.name}
      </Section.Title>
      <MansoryGrid>
        {section.cards.map((card) => (
          <Card {...card} key={card.label} color={section.color} />
        ))}
      </MansoryGrid>
    </Section>
  );
};

function useSectionData() {
  const passportPaths = usePassportPaths();

  return useMemo<GridData>(() => {
    return {
      name: 'Семья',
      href: passportPaths.family,
      color: 'red',
      logEvent: 'page.home.family-section-title',
      cards: [
        {
          label: 'Мои близкие',
          href: passportPaths.family,
          cover: listAsset,
          logEvent: 'page.home.family-card',
        },
        {
          label: 'Семейная оплата',
          href: passportPaths.family,
          cover: paymentAsset,
          logEvent: 'page.home.family-payment-card',
        },
        // {
        //   label: 'Детские профили',
        //   href: passportPaths.family,
        //   cover: kidsAsset,
        //   logEvent: 'page.home.kids-profiles-card',
        // },
      ],
    };
  }, [passportPaths]);
}
