/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useMemo } from 'react';

import { useIdPaths } from '@client/shared/paths';

import cardsAsset from '../../assets/cards.png';
import cashbackAsset from '../../assets/cashback.png';
import paymentsAsset from '../../assets/payments.png';
import receiptsAsset from '../../assets/receipts.png';
import type { GridData } from '../../types';
import { Card } from '../Card';
import { MansoryGrid } from '../MansoryGrid';
import { Section } from '../Section';

export const PaymentsSectionGrid: VFC = () => {
  const section = useSectionData();

  return (
    <Section>
      <Section.Title href={section.href} logEvent={section.logEvent}>
        {section.name}
      </Section.Title>
      <MansoryGrid>
        {section.cards.map((card) => (
          <Card {...card} key={card.label} color={section.color} />
        ))}
      </MansoryGrid>
    </Section>
  );
};

function useSectionData() {
  const idPaths = useIdPaths();

  return useMemo<GridData>(() => {
    const result: GridData = {
      name: 'Yandex Pay',
      href: idPaths.pay,
      color: 'yellow',
      logEvent: 'page.home.pay-section-title',
      cards: [
        {
          label: 'Карты',
          href: idPaths.payAnchorBankCards,
          badge: 'pay',
          cover: cardsAsset,
          logEvent: 'page.home.bank-cards-card',
        },
        {
          label: 'История платежей',
          href: idPaths.payHistory,
          cover: paymentsAsset,
          logEvent: 'page.home.payment-history-card',
        },
        {
          label: 'Кешбэк',
          href: idPaths.payAnchorCashback,
          cover: cashbackAsset,
          logEvent: 'page.home.cashback-card',
        },
        {
          label: 'Чеки',
          href: idPaths.payReceipts,
          cover: receiptsAsset,
          logEvent: 'page.home.receipts-card',
        },
      ],
    };

    return result;
  }, [idPaths]);
}
