/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useMemo } from 'react';

import { useIdPaths, usePassportPaths } from '@client/shared/paths';

import aboutAsset from '../../assets/about.png';
import addressesAsset from '../../assets/addresses.png';
import contactsAsset from '../../assets/contacts.png';
import docsAsset from '../../assets/docs.png';
import gdprAsset from '../../assets/gdpr.png';
import publicAsset from '../../assets/public.png';
import type { GridData } from '../../types';
import { Card } from '../Card';
import { MansoryGrid } from '../MansoryGrid';
import { Section } from '../Section';

export const PersonalSectionGrid: VFC = () => {
  const section = useSectionData();

  return (
    <Section>
      <Section.Title href={section.href} logEvent={section.logEvent}>
        {section.name}
      </Section.Title>
      <MansoryGrid>
        {section.cards.map((card) => (
          <Card {...card} key={card.label} color={section.color} />
        ))}
      </MansoryGrid>
    </Section>
  );
};

function useSectionData() {
  const idPaths = useIdPaths();
  const passportPaths = usePassportPaths();

  return useMemo<GridData>(() => {
    return {
      name: 'Данные',
      href: idPaths.personal,
      color: 'orange',
      logEvent: 'page.home.personal-section-title',
      cards: [
        {
          label: 'Обо мне',
          href: idPaths.personalData,
          cover: aboutAsset,
          logEvent: 'page.home.personal-data-card',
        },
        {
          label: 'Документы',
          href: idPaths.documents,
          cover: docsAsset,
          logEvent: 'page.home.documents-card',
        },
        {
          label: 'Адреса',
          href: idPaths.addresses,
          cover: addressesAsset,
          logEvent: 'page.home.addresses-card',
        },
        {
          label: 'Мои контакты',
          href: idPaths.contacts,
          cover: contactsAsset,
          logEvent: 'page.home.contacts-card',
        },
        {
          label: 'Публичные данные',
          href: idPaths.personalPublicData,
          cover: publicAsset,
          logEvent: 'page.home.public-data-card',
        },
        {
          label: 'Управлять данными',
          href: passportPaths.dataManagement,
          cover: gdprAsset,
          logEvent: 'page.home.data-management-card',
        },
      ],
    };
  }, [idPaths, passportPaths]);
}
