import { FC } from 'react';

import { ArrowShortForward } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { RouterLink } from '@client/shared/libs/router-link';
import { Section as BaseSection } from '@client/shared/ui-kit';
import { createSlot, useSlots } from '@yandex-id/components/libs/slots';

import styles from './Section.module.css';

interface TitleProps {
  href?: string;
  logEvent?: string;
}

const TitleSlot = createSlot<TitleProps>('Section.Title');

const _Section: FC = (props) => {
  const slots = useSlots(props);

  const title = slots.get(TitleSlot);
  const linkProps = title?.props.logEvent ? logProps(title.props.logEvent) : {};

  return (
    <BaseSection className={styles.root}>
      {title && (
        <BaseSection.Title weight="bold">
          {title.props.href ? (
            <RouterLink href={title.props.href} className={styles.link} {...linkProps}>
              {title.rendered}
              <ArrowShortForward className={styles.icon} size={24} />
            </RouterLink>
          ) : (
            <>{title.rendered}</>
          )}
        </BaseSection.Title>
      )}
      {slots.children}
    </BaseSection>
  );
};

export const Section = Object.assign(_Section, {
  Title: TitleSlot,
});
