/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useMemo } from 'react';

import { useIdPaths } from '@client/shared/paths';

import activityAsset from '../../assets/activity.png';
import allowedAsset from '../../assets/allowed.png';
import loginMethodAsset from '../../assets/login-method.png';
import restoreAsset from '../../assets/restore.png';
import type { GridData } from '../../types';
import { Card } from '../Card';
import { MansoryGrid } from '../MansoryGrid';
import { Section } from '../Section';

export const SecuritySectionGrid: VFC = () => {
  const section = useSectionData();

  return (
    <Section>
      <Section.Title href={section.href} logEvent={section.logEvent}>
        {section.name}
      </Section.Title>
      <MansoryGrid>
        {section.cards.map((card) => (
          <Card {...card} key={card.label} color={section.color} />
        ))}
      </MansoryGrid>
    </Section>
  );
};

function useSectionData() {
  const idPaths = useIdPaths();

  return useMemo<GridData>(() => {
    return {
      name: 'Безопасность',
      href: idPaths.security,
      color: 'blue',
      logEvent: 'page.home.security-section-title',
      cards: [
        {
          label: 'Активность в аккаунте',
          href: idPaths.activity,
          cover: activityAsset,
          logEvent: 'page.home.activity-card',
        },
        {
          label: 'Доступы',
          href: idPaths.securityExternalAccesses,
          cover: allowedAsset,
          logEvent: 'page.home.external-accesses-card',
        },
        {
          label: 'Способ входа',
          href: idPaths.securityEnterMethods,
          cover: loginMethodAsset,
          logEvent: 'page.home.enter-methods-card',
        },
        {
          label: 'Средства восстановления',
          href: idPaths.securityRecoveryMethods,
          cover: restoreAsset,
          logEvent: 'page.home.recovery-methods.card',
        },
      ],
    };
  }, [idPaths]);
}
