/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useMemo } from 'react';

import { useExternalPaths } from '@client/shared/paths';

import plusAsset from '../../assets/plus.png';
import practAsset from '../../assets/pract.png';
import yandex360Asset from '../../assets/yandex-360.png';
import type { GridData } from '../../types';
import { Card } from '../Card';
import { MansoryGrid } from '../MansoryGrid';
import { Section } from '../Section';

export const SubscriptionsSectionGrid: VFC = () => {
  const section = useSectionData();

  return (
    <Section>
      <Section.Title href={section.href} logEvent={section.logEvent}>
        {section.name}
      </Section.Title>
      <MansoryGrid>
        {section.cards.map((card) => (
          <Card {...card} key={card.label} color={section.color} />
        ))}
      </MansoryGrid>
    </Section>
  );
};

function useSectionData() {
  const externalPaths = useExternalPaths();

  return useMemo<GridData>(() => {
    return {
      name: 'Подписки',
      color: 'violet',
      cards: [
        {
          label: 'Плюс',
          href: externalPaths.plusIsInactive,
          cover: plusAsset,
          logEvent: 'page.home.yandex-plus-card',
        },
        {
          label: '360',
          href: externalPaths.yandex360,
          cover: yandex360Asset,
          logEvent: 'page.home.yandex-360-card',
        },
        {
          label: 'Практикум',
          href: externalPaths.praktikum,
          cover: practAsset,
          logEvent: 'page.home.praktikum-card',
        },
      ],
    };
  }, [externalPaths]);
}
