import { Keyset, getI18nLang, i18nFactory, i18nRawFactory } from '@client/shared/libs/i18n';

type KeysetType = typeof import('./ru')['ru'];

export let i18n = i18nFactory<KeysetType>(undefined, module.id);
export let i18nRaw = i18nRawFactory<KeysetType>(undefined, module.id);

if (typeof window !== 'undefined') {
  // на клиенте грузим только один нужный язык
  // при этом сервер в момент SSR заранее допушит нужные бандлы на клиента
  const lang = getI18nLang();

  import(
    /*
      webpackInclude: /\.ts$/,
      webpackExclude: /index\.ts$/,
      webpackChunkName: "lang-history-[request]-[index]",
      webpackMode: "lazy",
    */
    `./${lang}.ts`
  ).then((mod) => {
    i18n = i18nFactory(
      {
        [lang]: mod[lang],
      } as Keyset<KeysetType>,
      module.id,
    );
    i18nRaw = i18nRawFactory(
      {
        [lang]: mod[lang],
      } as Keyset<KeysetType>,
      module.id,
    );
  });
} else {
  // на сервере загружаем сразу все языковые кисеты (включаются в общий бандл кода)
  const loadLangFiles = require.context(`./`, false, /\/[a-z]{2}\.ts/, 'eager');

  Promise.all(loadLangFiles.keys().map((keysetFile) => loadLangFiles(keysetFile))).then((mods) => {
    i18n = i18nFactory(Object.assign({}, ...mods) as Keyset<KeysetType>, module.id);
    i18nRaw = i18nRawFactory(Object.assign({}, ...mods) as Keyset<KeysetType>, module.id);
  });
}
