import { NextPage } from 'next';

import { DocumentTitle } from '@client/shared/libs/document-title';
import { SectionStack } from '@client/shared/ui-kit';
import { PaymentsHistory } from '@client/widgets/PaymentsHistory';

import { i18n } from './i18n';

const History: NextPage = () => {
  return (
    <>
      <DocumentTitle>{i18n('История платежей')}</DocumentTitle>
      <SectionStack>
        <PaymentsHistory />
      </SectionStack>
    </>
  );
};

export default History;
