import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { BankCards } from '@client/widgets/BankCards/BankCards';
import { Cashback } from '@client/widgets/Cashback';
import { EdadealConnect } from '@client/widgets/EdadealConnect';
import { FinanceShortcuts } from '@client/widgets/FinanceShortcuts';
import { FuturePayments } from '@client/widgets/FuturePayments';
import { PaymentsHistory } from '@client/widgets/PaymentsHistory';

const YandexPay: NextPage = () => {
  return (
    <>
      <DocumentTitle>Yandex Pay</DocumentTitle>
      <SectionStack>
        <FinanceShortcuts />
        <BankCards />
        <FuturePayments />
        <Cashback />
        <PaymentsHistory shortHistory />
      </SectionStack>
      <EdadealConnect />
    </>
  );
};

export default YandexPay;
