import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { Contacts } from '@client/widgets/Contacts/Contacts';
import { DataManagement } from '@client/widgets/DataManagement';
import { Profile } from '@client/widgets/Profile';
import { ProfileFill } from '@client/widgets/ProfileFill';
import { PublicData } from '@client/widgets/PublicData';
import { AddressesCards } from '@client/widgets/addresses-cards';
import { DocumentsThumbs } from '@client/widgets/documents-thumbs';

import { i18n } from './i18n';

const PersonalPage: NextPage = () => {
  return (
    <>
      <DocumentTitle>{i18n('Персональные данные')}</DocumentTitle>
      <SectionStack>
        <Profile />
        <ProfileFill />
        <DocumentsThumbs />
        <AddressesCards />
        <Contacts />
        <PublicData />
        <DataManagement />
      </SectionStack>
    </>
  );
};

export default PersonalPage;
