import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { AuthTypes } from '@client/widgets/AuthTypes';
import { LoginWithExternalAccounts } from '@client/widgets/LoginWithExternalAccounts';
import { LoginWithQR } from '@client/widgets/LoginWithQR';

import { i18n } from './i18n';

const EnterMethodsPage: NextPage = () => {
  return (
    <>
      <DocumentTitle>{i18n('Способы входа')}</DocumentTitle>
      <SectionStack>
        <AuthTypes />
        <LoginWithQR />
        <LoginWithExternalAccounts />
      </SectionStack>
    </>
  );
};

export default EnterMethodsPage;
