import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { ExternalAccountProviders } from '@client/widgets/ExternalAccountProviders';
import { ExternalAccounts } from '@client/widgets/ExternalAccounts';

import { i18n } from './i18n';

const ExternalAccountsPage: NextPage = () => {
  return (
    <>
      <DocumentTitle>{i18n('Внешние аккаунты')}</DocumentTitle>
      <SectionStack>
        <ExternalAccounts />
        <ExternalAccountProviders />
      </SectionStack>
    </>
  );
};

export default ExternalAccountsPage;
