import { DocumentTitle } from '@client/shared/libs/document-title';
import { NextPage } from '@client/shared/page-layouts';
import { SectionStack } from '@client/shared/ui-kit';
import { Activity } from '@client/widgets/Activity';
import { EnterMethods } from '@client/widgets/EnterMethods';
import { ExternalAccesses } from '@client/widgets/ExternalAccesses';
import { RecoveryMethods } from '@client/widgets/RecoveryMethods';
import { SecurityShortcuts } from '@client/widgets/SecurityShortcuts';

import { i18n } from './i18n';

const SecurityPage: NextPage = () => {
  return (
    <>
      <DocumentTitle>{i18n('Безопасность')}</DocumentTitle>
      <SectionStack>
        <SecurityShortcuts />
        <EnterMethods />
        <RecoveryMethods />
        <Activity />
        <ExternalAccesses />
      </SectionStack>
    </>
  );
};

export default SecurityPage;
