import { URL } from 'url';

import { Controller, Get, Query, Redirect } from '@nestjs/common';

@Controller()
export class EmailController {
  @Get('security/activate-recovery-email')
  @Redirect()
  async activateRecoveryEmail(@Query('retpath') redirectUrl: string, @Query('key') code: string) {
    const url = new URL(redirectUrl);

    url.search = '';
    url.searchParams.append('action', 'activate-recovery-email');
    url.searchParams.append('code', code);

    return {
      url: url.href,
    };
  }
}
