import { Args, Mutation, Resolver } from '@nestjs/graphql';
import {
  AddRecoveryEmailInput,
  ConfirmRecoveryEmailByCodeInput,
  ConfirmRecoveryEmailByLinkInput,
  RemoveRecoveryEmailInput,
} from '@server/graphql-schema';

import { EmailService } from './email.service';

@Resolver()
export class EmailResolver {
  constructor(private email: EmailService) {}

  @Mutation('accountAddRecoveryEmail')
  async addRecoveryEmail(@Args('input') input: AddRecoveryEmailInput) {
    return this.email.addRecoveryEmail(input);
  }

  @Mutation('accountRemoveRecoveryEmail')
  async removeRecoveryEmail(@Args('input') input: RemoveRecoveryEmailInput) {
    return this.email.removeRecoveryEmail(input);
  }

  @Mutation('accountConfirmRecoveryEmailByLink')
  async confirmRecoveryEmailByLink(@Args('input') input: ConfirmRecoveryEmailByLinkInput) {
    return this.email.confirmEmailByLink(input);
  }

  @Mutation('accountConfirmRecoveryEmailByCode')
  async confirmRecoveryEmailByCode(@Args('input') input: ConfirmRecoveryEmailByCodeInput) {
    return this.email.confirmEmailByCode(input);
  }
}
