import { Args, Mutation, Query, Resolver } from '@nestjs/graphql';
import {
  ToggleLoginWithExternalAccountInput,
  UnbindExternalAccountInput,
} from '@server/graphql-schema';

import { ExternalAccountService } from './external-account.service';

@Resolver('ExternalAccount')
export class ExternalAccountResolver {
  constructor(private externalAccountService: ExternalAccountService) {}

  @Query('externalAccounts')
  async externalAccounts() {
    const accounts = await this.externalAccountService.getAccounts();

    return accounts;
  }

  @Query('externalAccountProviders')
  externalAccountProviders() {
    return this.externalAccountService.getAccountProviders();
  }

  @Mutation('unbindExternalAccount')
  unbindExternalAccount(@Args('input') input: UnbindExternalAccountInput) {
    return this.externalAccountService.unbindAccount(input);
  }

  @Mutation('toggleLoginWithExternalAccount')
  enableLoginWithExternalAccount(@Args('input') input: ToggleLoginWithExternalAccountInput) {
    return this.externalAccountService.toggleLoginWithAccount(input);
  }
}
