import express from 'express';
import getRealIp from 'express-real-ip';

import { NestApplicationOptions } from '@nestjs/common';
import { NestFactory } from '@nestjs/core';
import { ExpressAdapter, NestExpressApplication } from '@nestjs/platform-express';

import { AppModule } from './app.module';

export async function bootstrap(options?: NestApplicationOptions) {
  // Балансер присылает адрес клиента в заголовке X-Real-Ip
  // Express по умолчанию парсит только X-Forwarded-For
  // Инитим експресс сами и подкладываем мидлварь, которая парсит нужный заголовок
  const app = express();

  app.disable('x-powered-by');
  app.enable('trust proxy');
  app.use(getRealIp());

  // Теперь уже на этом экспрессе заводим Nestjs
  const nestApp = await NestFactory.create<NestExpressApplication>(
    AppModule.register(),
    new ExpressAdapter(app),
    options,
  );

  return nestApp;
}
