// период обновления значения используемых ресурсов
const CYCLE = 500;

function getUsageValue() {
  const { system, user } = process.cpuUsage();

  return system + user;
}

export const getCPUUsage = (() => {
  const usageValue = getUsageValue();
  const startDate = process.hrtime.bigint();

  const usageData = {
    now: {
      value: usageValue,
      ts: startDate,
    },
    was: {
      value: usageValue,
      ts: startDate,
    },
  };

  // запускаем тикер, чтобы раз в CYCLE сохранять текущее потребление проца
  // используем это значение как отправную точку для вычисления
  const ticker = setInterval(() => {
    // храним предпоследнее значение, чтобы всегда получать усреднённое значение за [2*CYCLE, CYCLE] времени
    usageData.was = usageData.now;
    usageData.now = {
      value: getUsageValue(),
      ts: process.hrtime.bigint(),
    };
  }, CYCLE);

  ticker.unref();

  return () => {
    const { ts, value } = usageData.was;

    // Использование проца в микросекундах, а время в наносекундах -> нужно умножить на 1000
    // А чтобы получить в процентах то еще на 100, итого: 100_000
    return Number(BigInt((getUsageValue() - value) * 100_000) / (process.hrtime.bigint() - ts));
  };
})();
