import { DynamicModule } from '@nestjs/common';
import { ConfigModule as NestJsConfigModule } from '@nestjs/config';
import { TldModule } from '@yandex-int/nest-common';

import * as services from './services';

const configs = Object.values(services);

export class ConfigModule {
  static forRoot(): DynamicModule {
    return {
      module: ConfigModule,
      global: true,
      providers: configs,
      imports: [TldModule, NestJsConfigModule.forRoot()],
      exports: configs,
    };
  }
}
