import { Injectable } from '@nestjs/common';
import type {
  HttpConfig,
  HttpModuleOptions,
  HttpModuleOptionsFactory,
} from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface AddressOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<AddressOptions> = {
  common: {
    url: 'http://address-test.pers.yandex.net',
    timeout: 2500,
  },
  production: {
    url: 'http://address-prod.pers.yandex.net',
  },
};

@Injectable()
export class AddressConfigService implements HttpModuleOptionsFactory {
  get options(): AddressOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'address',
      useUserTicket: true,
    };
  }
}
