import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface BillsOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<BillsOptions> = {
  common: {
    url: 'https://test.bills.pay.yandex.ru',
    timeout: 20000,
  },
  production: {
    url: 'https://bills.pay.yandex.ru',
  },
};

@Injectable()
export class BillsConfigService {
  get options(): BillsOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'bills_backend',
      useUserTicket: true,
    };
  }
}
