import { Injectable } from '@nestjs/common';
import {
  BLACKBOX_ATTRIBUTES,
  BLACKBOX_PHONE_ATTRIBUTES,
  __TODO_BLACKBOX_ATTRIBUTES,
} from '@server/shared/blackbox/constants';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';
import type { BlackboxOptions } from '@yandex-int/nest-infra';

import { EnvConfig, getEnvConfig } from '../env-config';

const config: EnvConfig<
  BlackboxOptions & { get_public_name?: string; allow_child?: string; get_public_id?: string }
> = {
  common: {
    tvmServiceName: 'blackbox',
    api: 'https://blackbox-test.yandex.net',
    aliases: 'all',
    timeout: 2500,
    get_public_name: 'yes',
    get_public_id: 'yes',
    allow_child: 'true',
    attributes: {
      lang: BLACKBOX_ATTRIBUTES['person.language'],
      havePlus: BLACKBOX_ATTRIBUTES['account.have_plus'],
      lastPasswordUpdate: BLACKBOX_ATTRIBUTES['password.update_datetime'],
      is2faWithKey: BLACKBOX_ATTRIBUTES['account.2fa_on'],
      is2faWithSms: __TODO_BLACKBOX_ATTRIBUTES['account.sms_2fa_on'],
      isQrDisabled: __TODO_BLACKBOX_ATTRIBUTES['account.qr_code_login_forbidden'],
      fio: BLACKBOX_ATTRIBUTES['person.fio'],
      firstName: BLACKBOX_ATTRIBUTES['person.firstname'],
      lastName: BLACKBOX_ATTRIBUTES['person.lastname'],
      birthdate: BLACKBOX_ATTRIBUTES['person.birthdate'],
      isChild: BLACKBOX_ATTRIBUTES['account.is_child'],
      city: BLACKBOX_ATTRIBUTES['person.city'],
      question: BLACKBOX_ATTRIBUTES['hint.question.serialized'],
      hasPublicIdSet: BLACKBOX_ATTRIBUTES['account.has_custom_public_id'],
      gender: BLACKBOX_ATTRIBUTES['person.gender'],
      country: BLACKBOX_ATTRIBUTES['person.country'],
      timezone: BLACKBOX_ATTRIBUTES['person.timezone'],
      hasFamilyPlus: __TODO_BLACKBOX_ATTRIBUTES['account.has_family_plus'],
    },
    emails: 'getall',
    phones: {
      kind: 'all',
      attributes: {
        phone: BLACKBOX_PHONE_ATTRIBUTES['phone.formatted_number'],
        e164number: BLACKBOX_PHONE_ATTRIBUTES['phone.e164_number'],
        isDefault: BLACKBOX_PHONE_ATTRIBUTES['phone.is_default'],
        isSecured: BLACKBOX_PHONE_ATTRIBUTES['phone.is_secured'],
        isBound: BLACKBOX_PHONE_ATTRIBUTES['phone.is_bound'],
      },
    },
    get_family_info: 'yes',
    getphoneoperations: 'yes',
  },
  testing: {
    getYaboxOptions: (req) =>
      // т.к. в режиме тестинга работают автобеты не на домене passport, то там такой куки нет, и она не нужна
      // а на настоящем тестинге нужна
      // https://st.yandex-team.ru/PASSP-37187
      process.env.USE_SESSGUARD
        ? {
            sessguard: req.cookies.sessguard,
          }
        : {},
  },
  stress: {
    api: 'https://pass-load.sezam.yandex.net',
  },
  rc: {
    api: 'https://blackbox-rc.yandex.net',
  },
  production: {
    api: 'https://blackbox.yandex.net',
    getYaboxOptions: (req) => ({
      sessguard: req.cookies.sessguard,
    }),
  },
};

@Injectable()
export class BlackboxConfigService {
  get options(): BlackboxOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.api,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'blackbox',
      useUserTicket: true,
    };
  }
}
