import { Injectable } from '@nestjs/common';

import { EnvConfig, getEnvConfig } from '../env-config';

interface BunkerOptions {
  apiHost: string;
  version: 'stable' | 'latest';
  ohioProject: string;
  timeout: number;
}

const config: EnvConfig<BunkerOptions> = {
  common: {
    apiHost: 'bunker-api-dot.yandex.net',
    version: 'latest',
    ohioProject: '/passport-order-history-test',
    timeout: 1400,
  },
  production: {
    apiHost: 'bunker-api.yandex.net',
    version: 'latest',
    ohioProject: '/passport-order-history',
  },
};

@Injectable()
export class BunkerConfigService {
  get options(): BunkerOptions {
    return getEnvConfig(config);
  }
}
