import { Injectable } from '@nestjs/common';
import type {
  HttpConfig,
  HttpModuleOptions,
  HttpModuleOptionsFactory,
} from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface DiskOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<DiskOptions> = {
  common: {
    url: 'https://cloud-api.dst.yandex.net:8443',
    timeout: 20000,
  },
  production: {
    url: 'https://intapi.disk.yandex.net:8443',
  },
};

@Injectable()
export class DiskConfigService implements HttpModuleOptionsFactory {
  get options(): DiskOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'disk',
      useUserTicket: true,
    };
  }
}
