import { Injectable } from '@nestjs/common';
import type {
  HttpConfig,
  HttpModuleOptions,
  HttpModuleOptionsFactory,
} from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface DocumentsOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<DocumentsOptions> = {
  common: {
    url: 'https://documents-test.pers.yandex.net',
    timeout: 10000,
  },
  production: {
    url: 'https://documents-prod.pers.yandex.net',
  },
};

@Injectable()
export class DocumentsConfigService implements HttpModuleOptionsFactory {
  get options(): DocumentsOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'documents',
      useUserTicket: true,
    };
  }
}
