import { Injectable } from '@nestjs/common';
import { HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

export interface ExperimentsOptions {
  handlerName: 'PASSPORT';
  disabled: boolean;
  timeout: number;
  ecooUrl: string;
  abUrl: string;
}

const config: EnvConfig<ExperimentsOptions> = {
  common: {
    handlerName: 'PASSPORT',
    disabled: process.env.USE_AB === '0',
    timeout: 2000,
    ecooUrl: 'https://yandex.ru/ecoo/check',
    abUrl: 'http://uaas.search.yandex.net',
  },
};

@Injectable()
export class ExperimentsConfigService {
  get options(): ExperimentsOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig() {
    return {};
  }
}
