import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface FamilyPayOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<FamilyPayOptions> = {
  common: {
    url: 'https://familypay-backend-test.so.yandex.net',
    timeout: 20000,
  },
  production: {
    url: 'https://familypay-backend.so.yandex.net',
  },
};

@Injectable()
export class FamilyPayConfigService {
  get options(): FamilyPayOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'familypay_backend',
      useUserTicket: true,
    };
  }
}
